/////////////////////////////////////////////////////////////
// CINEMA SDK : OBJECTS      															 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D V8      												 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4DOBJECTDATA_H
#define __C4DOBJECTDATA_H

#include "c4d_nodedata.h"
 
class  PluginObject;
class  SplineObject;
class  RootTextureString;
class  BaseBitmap;
class  BaseDraw;
class  BaseDrawHelp;
class  Particle;
class  BaseThread;
class  HierarchyHelp;
class  BaseObject;
class  PriorityList;
struct BaseParticle;


class ObjectData : public NodeData
{
	public:
		////inherited from NodeData////
		//virtual Bool Init(GeListNode *node);
		//virtual void Free(GeListNode *node);
		//virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		//virtual Bool Write(GeListNode *node, HyperFile *hf);
		//virtual Bool Message(GeListNode *node, LONG type, void *data);
		//virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		//virtual void GetBubbleHelp(GeListNode *node, String &str);
		//virtual BaseDocument* GetDocument(GeListNode *node);
		//virtual LONG GetBranchInfo(GeListNode *node, BranchInfo *info, LONG max);
		//virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		//virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		//virtual Bool GetDEnabling(GeListNode *node, const DescID &id,GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		//virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
		//static NodeData *Alloc(void) { return gNew MyNodeData; }
		////inherited from NodeData////

		virtual void GetDimension(PluginObject *op, Vector *mp, Vector *rad);
		virtual Bool Draw(PluginObject *op, LONG drawpass, BaseDraw *bd, BaseDrawHelp *bh);
		virtual LONG DetectHandle(PluginObject *op, BaseDraw *bd, LONG x, LONG y, LONG qualifier);
		virtual Bool MoveHandle(PluginObject *op, PluginObject *undo, const Matrix &tm, LONG hit_id, LONG qualifier);
		virtual Bool AddToExecution(PluginObject *op, PriorityList *list);
		virtual LONG Execute(PluginObject *op, BaseDocument *doc, BaseThread *bt, LONG priority, LONG flags);
		
		// generator
		virtual BaseObject* GetVirtualObjects(PluginObject *op, HierarchyHelp *hh);

		// modifier
		virtual Bool ModifyObject(PluginObject *mod, BaseDocument *doc, BaseObject *op, const Matrix &op_mg, const Matrix &mod_mg, Real lod, LONG flags, BaseThread *thread);
		virtual void CheckDirty(PluginObject *op, BaseDocument *doc);
		
		// spline
		virtual SplineObject* GetContour(PluginObject *op, BaseDocument *doc, Real lod, BaseThread *bt);

		// particle
		virtual void ModifyParticles(PluginObject *op, Particle *pp, BaseParticle *ss, LONG pcnt, Real diff);

		// helper routines
		virtual LONG GetHandleCount(PluginObject *op);
		virtual Vector GetHandle(PluginObject *op, LONG i);
		virtual void SetHandle(PluginObject *op, LONG i, Vector p);
		};

Bool RegisterObjectPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, BaseBitmap *icon, BaseBitmap *icon_small, LONG disklevel, void *emulation=NULL);
Bool RegisterObjectPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, String icon, String icon_small, LONG disklevel);
Bool RegisterObjectPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, LONG disklevel);

#endif
